-- ~~~~
-- Edit: 4/8/16
-- Malicious File Upload/Edit Detection Script
-- This script is currently implemented and executed using ModSecurity Rules
-- Detects WordPress and Joomla Theme Edits
-- Detects file uploads through HTTP
-- Should block any files which match a regex in our ShellScannerPatterns
-- Written and maintained by Hostdime Abuse/Security Team
-- Edit: 4/22/16
-- Adding check and removal for files stored in /tmp
-- Edit 4/27/16
-- Commented out previous edit code for further testing
-- Updated paths to now be compatible with ModSec Vendors
-- Edit 8/24/16
-- Now deletes files blocked by this script to prevent disk usage
-- ~~Tom B.~~

function main()
    -- log start of script
    m.log(5, "Start ModSec Lua Malicious File Detection...");

    -- ensure we load posix library from specific directory
    package.cpath = '/etc/modsecurity/lib/?.so'
    local rex = require("rex_posix")

    -- local ip = m.getvar("REMOTE_ADDR")

    -- variables to help determine/detect uploads and edits
    local wpEdit = m.getvar("ARGS_POST.newcontent", "none")
    local joomEdit = m.getvar("ARGS_POST.jform[source]", "none")
    local tmpFile = m.getvar("FILES_TMPNAMES")

    -- Store the file edit/upload contents
    -- Store if we should run the regex checks
    local fileContents
    local success = false
    local output = "Malicious File Detected!"

    -- If there is a file upload, run this
    if tmpFile then
        -- log file upload detected
        m.log(5, "HTTP File Upload Detected...")

        -- open the file, and continue if successful
        local f = io.open(tmpFile, "r")
        if f then
            -- change standart io input to the file
            io.input(f)

            -- read all contents of the file
            fileContents = io.read("*a")

            -- if contents were not read, exit 
            if not fileContents then
                m.log(5, "Empty File Detected -- Not Scanning")
                return nil
            else
                -- everything was successful, tell script to run checks
                output = "Malicious File Upload Detected!"
                success = true
            end
        else
            m.log(5, "Could not open file")
            return nil
        end

        io.close(f)
    end

    -- if a wordpress file edit was detected
    if wpEdit then
        -- log a WordPress Edit was found
        m.log(5, "WordPress Edit Detected...")

        output = "Malicious WordPress File Edit Detected!"
        success = true
        fileContents = wpEdit
    end

    -- if joomla edit detected, run this
    if joomEdit then
        -- log a Joomla Edit detected
        m.log(5, "Joomla Edit Detected...")

        output = "Malicious Joomla File Edit Detected!"
        success = true
        fileContents = joomEdit
    end


    -- if file contents were gathered, run regex checks
    local ret = false
    if success then
        local result

        -- read and check regex lines
        for line in io.lines("/etc/modsecurity/ShellScannerPatterns") do
            result = rex.match(fileContents, line);
            if result then
                -- log regex that are hit, parse out matched rule
                parse = string.match(line, "_%-.-%-_")
                m.log(5, parse)
                output = output .. " (Rule: " .. parse .. ") "

                -- set that a rule was matched, break out of for loop
                ret = true
                break
            end
        end
    end

    -- log end of script execution
    m.log(5, "End of ModSec Lua Malicious File Detection...")

    -- return whether this file was malicious
    if ret then
        -- log malicious file found
        m.log(5, "Malicious File Found, Sending Script Output...")

        -- (DISABLED again as we now use SecTmpSaveUploadedFiles) Ensure malicious file does not remain in /tmp
        if tmpFile then
            m.log(5, "Removing malicious file from UploadDir...")
            os.remove(tmpFile)
        end

        return output
    else
        -- log file was clean
        m.log(5, "Nothing Malicious Detected...")

        return nil
    end
end
